{-# OPTIONS_GHC -fno-warn-unused-binds -fno-warn-missing-signatures #-}
{-# LANGUAGE CPP #-}
{-# LINE 1 "Scanner.x" #-}

module Scanner where

#if __GLASGOW_HASKELL__ >= 603
#include "ghcconfig.h"
#elif defined(__GLASGOW_HASKELL__)
#include "config.h"
#endif
#if __GLASGOW_HASKELL__ >= 503
import Data.Array
#else
import Array
#endif
{-# LINE 1 "templates/wrappers.hs" #-}
-- -----------------------------------------------------------------------------
-- Alex wrapper code.
--
-- This code is in the PUBLIC DOMAIN; you may copy it freely and use
-- it for any purpose whatsoever.





import Data.Word (Word8)
















import Data.Char (ord)
import qualified Data.Bits

-- | Encode a Haskell String to a list of Word8 values, in UTF8 format.
utf8Encode :: Char -> [Word8]
utf8Encode = uncurry (:) . utf8Encode'

utf8Encode' :: Char -> (Word8, [Word8])
utf8Encode' c = case go (ord c) of
                  (x, xs) -> (fromIntegral x, map fromIntegral xs)
 where
  go oc
   | oc <= 0x7f       = ( oc
                        , [
                        ])

   | oc <= 0x7ff      = ( 0xc0 + (oc `Data.Bits.shiftR` 6)
                        , [0x80 + oc Data.Bits..&. 0x3f
                        ])

   | oc <= 0xffff     = ( 0xe0 + (oc `Data.Bits.shiftR` 12)
                        , [0x80 + ((oc `Data.Bits.shiftR` 6) Data.Bits..&. 0x3f)
                        , 0x80 + oc Data.Bits..&. 0x3f
                        ])
   | otherwise        = ( 0xf0 + (oc `Data.Bits.shiftR` 18)
                        , [0x80 + ((oc `Data.Bits.shiftR` 12) Data.Bits..&. 0x3f)
                        , 0x80 + ((oc `Data.Bits.shiftR` 6) Data.Bits..&. 0x3f)
                        , 0x80 + oc Data.Bits..&. 0x3f
                        ])



type Byte = Word8

-- -----------------------------------------------------------------------------
-- The input type
















































































-- -----------------------------------------------------------------------------
-- Token positions

-- `Posn' records the location of a token in the input text.  It has three
-- fields: the address (number of chacaters preceding the token), line number
-- and column of a token within the file. `start_pos' gives the position of the
-- start of the file and `eof_pos' a standard encoding for the end of file.
-- `move_pos' calculates the new position after traversing a given character,
-- assuming the usual eight character tab stops.














-- -----------------------------------------------------------------------------
-- Monad (default and with ByteString input)

























































































































































-- -----------------------------------------------------------------------------
-- Basic wrapper


type AlexInput = (Char,[Byte],String)

alexInputPrevChar :: AlexInput -> Char
alexInputPrevChar (c,_,_) = c

-- alexScanTokens :: String -> [token]
alexScanTokens str = go ('\n',[],str)
  where go inp__@(_,_bs,s) =
          case alexScan inp__ 0 of
                AlexEOF -> []
                AlexError _ -> error "lexical error"
                AlexSkip  inp__' _ln     -> go inp__'
                AlexToken inp__' len act -> act (take len s) : go inp__'

alexGetByte :: AlexInput -> Maybe (Byte,AlexInput)
alexGetByte (c,(b:bs),s) = Just (b,(c,bs,s))
alexGetByte (_,[],[])    = Nothing
alexGetByte (_,[],(c:s)) = case utf8Encode' c of
                             (b, bs) -> Just (b, (c, bs, s))



-- -----------------------------------------------------------------------------
-- Basic wrapper, ByteString version
































-- -----------------------------------------------------------------------------
-- Posn wrapper

-- Adds text positions to the basic model.













-- -----------------------------------------------------------------------------
-- Posn wrapper, ByteString version














-- -----------------------------------------------------------------------------
-- GScan wrapper

-- For compatibility with previous versions of Alex, and because we can.














alex_tab_size :: Int
alex_tab_size = 8
alex_base :: Array Int Int
alex_base = listArray (0 :: Int, 155)
  [ -31
  , -35
  , -33
  , 95
  , 223
  , 336
  , 0
  , 464
  , 0
  , 577
  , 0
  , 642
  , 0
  , 707
  , 963
  , 899
  , 0
  , 1155
  , 1273
  , 1092
  , 0
  , 1481
  , 1529
  , 1300
  , 0
  , 0
  , 1310
  , -56
  , -55
  , -54
  , 0
  , 0
  , 0
  , 0
  , -34
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 1519
  , 1737
  , 1812
  , 1887
  , 1962
  , 2037
  , 2112
  , 2187
  , 2262
  , 2337
  , 2412
  , 2487
  , 2562
  , 2637
  , 2712
  , 2787
  , 2862
  , 2937
  , 3012
  , 3087
  , 3162
  , 3237
  , 1322
  , 3314
  , 0
  , 1332
  , 0
  , 0
  , 0
  , 3327
  , 3387
  , 3462
  , 3537
  , 3612
  , 3687
  , 3762
  , 3837
  , 3912
  , 3987
  , 4062
  , 4137
  , 4212
  , 4287
  , 4362
  , 4437
  , 4512
  , 4587
  , 4662
  , 4737
  , 4812
  , 4887
  , 4962
  , 5037
  , 5112
  , 5187
  , 5262
  , 5337
  , 5412
  , 5487
  , 5562
  , 5637
  , 5712
  , 5787
  , 5862
  , 5937
  , 6012
  , 6087
  , 6162
  , 6237
  , 6312
  , 6387
  , 6462
  , 6537
  , 6612
  , 6687
  , 6762
  , 6837
  , 6912
  , 6987
  , 7062
  , 7137
  , 7212
  , 7287
  , 7362
  , 7437
  , 7512
  , 7587
  , 7662
  , 7737
  , 7812
  , 7887
  , 7962
  , 8037
  , 8112
  , 8187
  , 8262
  , 8337
  , 8412
  , 8487
  , 8562
  , 8637
  , 8712
  , 8787
  , 8862
  , 8937
  , 9012
  , 9087
  , 9162
  , 9237
  , 9312
  , 0
  ]

alex_table :: Array Int Int
alex_table = listArray (0 :: Int, 9567)
  [ 0
  , 155
  , 34
  , 22
  , 71
  , 32
  , 30
  , 31
  , 18
  , 39
  , 40
  , 37
  , 35
  , 25
  , 36
  , 26
  , 38
  , 68
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 33
  , 24
  , 28
  , 27
  , 29
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 122
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 43
  , 0
  , 44
  , 0
  , 0
  , 0
  , 121
  , 129
  , 107
  , 120
  , 137
  , 92
  , 120
  , 120
  , 152
  , 120
  , 120
  , 113
  , 120
  , 111
  , 120
  , 116
  , 120
  , 117
  , 124
  , 135
  , 120
  , 109
  , 130
  , 120
  , 120
  , 120
  , 41
  , 0
  , 42
  , 17
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 14
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 2
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 11
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 3
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 13
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 15
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 19
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 23
  , 0
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 70
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 69
  , 0
  , 0
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 17
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 20
  , 19
  , 2
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 12
  , 13
  , 4
  , 8
  , 8
  , 8
  , 9
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , -1
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 72
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 14
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 16
  , 15
  , 3
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 10
  , 11
  , 7
  , 6
  , 6
  , 6
  , 5
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 123
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 23
  , 0
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 67
  , 0
  , 0
  , 0
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 0
  , 0
  , 0
  , 0
  , 0
  , 69
  , 0
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 0
  , 0
  , 0
  , 0
  , 21
  , 73
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 74
  , 74
  , 74
  , 74
  , 74
  , 74
  , 0
  , 0
  , 0
  , 0
  , 21
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 46
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 47
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 48
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 49
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 51
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 53
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 54
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 56
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 63
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 64
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 65
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 66
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 154
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 75
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 76
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 77
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 78
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 134
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 153
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 80
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 81
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 151
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 82
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 149
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 148
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 145
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 85
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 86
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 87
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 90
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 91
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 144
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 94
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 96
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 99
  , 120
  , 120
  , 120
  , 103
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 143
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 97
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 98
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 142
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 141
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 140
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 139
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 136
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 132
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 128
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 127
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 125
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 119
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 126
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 131
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 114
  , 120
  , 120
  , 115
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 133
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 112
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 110
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 108
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 118
  , 120
  , 120
  , 106
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 105
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 104
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 138
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 102
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 101
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 100
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 95
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 93
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 89
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 88
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 84
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 83
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 147
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 150
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 79
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 62
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 61
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 60
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 59
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 58
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 57
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 55
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 52
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 146
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 50
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 45
  , 120
  , 120
  , 120
  , 120
  , 120
  , 120
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  , 0
  ]

alex_check :: Array Int Int
alex_check = listArray (0 :: Int, 9567)
  [ -1
  , 32
  , 33
  , 34
  , 39
  , 61
  , 61
  , 61
  , 39
  , 40
  , 41
  , 42
  , 43
  , 44
  , 45
  , 46
  , 47
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , 61
  , 59
  , 60
  , 61
  , 62
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , 91
  , -1
  , 93
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 123
  , -1
  , 125
  , 128
  , 129
  , 130
  , 131
  , 132
  , 133
  , 134
  , 135
  , 136
  , 137
  , 138
  , 139
  , 140
  , 141
  , 142
  , 143
  , 144
  , 145
  , 146
  , 147
  , 148
  , 149
  , 150
  , 151
  , 152
  , 153
  , 154
  , 155
  , 156
  , 157
  , 158
  , 159
  , 160
  , 161
  , 162
  , 163
  , 164
  , 165
  , 166
  , 167
  , 168
  , 169
  , 170
  , 171
  , 172
  , 173
  , 174
  , 175
  , 176
  , 177
  , 178
  , 179
  , 180
  , 181
  , 182
  , 183
  , 184
  , 185
  , 186
  , 187
  , 188
  , 189
  , 190
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 128
  , 129
  , 130
  , 131
  , 132
  , 133
  , 134
  , 135
  , 136
  , 137
  , 138
  , 139
  , 140
  , 141
  , 142
  , 143
  , 144
  , 145
  , 146
  , 147
  , 148
  , 149
  , 150
  , 151
  , 152
  , 153
  , 154
  , 155
  , 156
  , 157
  , 158
  , 159
  , 160
  , 161
  , 162
  , 163
  , 164
  , 165
  , 166
  , 167
  , 168
  , 169
  , 170
  , 171
  , 172
  , 173
  , 174
  , 175
  , 176
  , 177
  , 178
  , 179
  , 180
  , 181
  , 182
  , 183
  , 184
  , 185
  , 186
  , 187
  , 188
  , 189
  , 190
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 128
  , 129
  , 130
  , 131
  , 132
  , 133
  , 134
  , 135
  , 136
  , 137
  , 138
  , 139
  , 140
  , 141
  , 142
  , 143
  , 144
  , 145
  , 146
  , 147
  , 148
  , 149
  , 150
  , 151
  , 152
  , 153
  , 154
  , 155
  , 156
  , 157
  , 158
  , 159
  , 160
  , 161
  , 162
  , 163
  , 164
  , 165
  , 166
  , 167
  , 168
  , 169
  , 170
  , 171
  , 172
  , 173
  , 174
  , 175
  , 176
  , 177
  , 178
  , 179
  , 180
  , 181
  , 182
  , 183
  , 184
  , 185
  , 186
  , 187
  , 188
  , 189
  , 190
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 143
  , 144
  , 145
  , 146
  , 147
  , 148
  , 149
  , 150
  , 151
  , 152
  , 153
  , 154
  , 155
  , 156
  , 157
  , 158
  , 159
  , 160
  , 161
  , 162
  , 163
  , 164
  , 165
  , 166
  , 167
  , 168
  , 169
  , 170
  , 171
  , 172
  , 173
  , 174
  , 175
  , 176
  , 177
  , 178
  , 179
  , 180
  , 181
  , 182
  , 183
  , 184
  , 185
  , 186
  , 187
  , 188
  , 189
  , 190
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 128
  , 129
  , 130
  , 131
  , 132
  , 133
  , 134
  , 135
  , 136
  , 137
  , 138
  , 139
  , 140
  , 141
  , 142
  , 143
  , 144
  , 145
  , 146
  , 147
  , 148
  , 149
  , 150
  , 151
  , 152
  , 153
  , 154
  , 155
  , 156
  , 157
  , 158
  , 159
  , 160
  , 161
  , 162
  , 163
  , 164
  , 165
  , 166
  , 167
  , 168
  , 169
  , 170
  , 171
  , 172
  , 173
  , 174
  , 175
  , 176
  , 177
  , 178
  , 179
  , 180
  , 181
  , 182
  , 183
  , 184
  , 185
  , 186
  , 187
  , 188
  , 189
  , 190
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 143
  , 144
  , 145
  , 146
  , 147
  , 148
  , 149
  , 150
  , 151
  , 152
  , 153
  , 154
  , 155
  , 156
  , 157
  , 158
  , 159
  , 160
  , 161
  , 162
  , 163
  , 164
  , 165
  , 166
  , 167
  , 168
  , 169
  , 170
  , 171
  , 172
  , 173
  , 174
  , 175
  , 176
  , 177
  , 178
  , 179
  , 180
  , 181
  , 182
  , 183
  , 184
  , 185
  , 186
  , 187
  , 188
  , 189
  , 190
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 0
  , 1
  , 2
  , 3
  , 4
  , 5
  , 6
  , 7
  , 8
  , 9
  , 10
  , 11
  , 12
  , 13
  , 14
  , 15
  , 16
  , 17
  , 18
  , 19
  , 20
  , 21
  , 22
  , 23
  , 24
  , 25
  , 26
  , 27
  , 28
  , 29
  , 30
  , 31
  , 32
  , 33
  , 34
  , 35
  , 36
  , 37
  , 38
  , 39
  , 40
  , 41
  , 42
  , 43
  , 44
  , 45
  , 46
  , 47
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , 58
  , 59
  , 60
  , 61
  , 62
  , 63
  , 64
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , 91
  , 92
  , 93
  , 94
  , 95
  , 96
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 123
  , 124
  , 125
  , 126
  , 127
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 0
  , 1
  , 2
  , 3
  , 4
  , 5
  , 6
  , 7
  , 8
  , 9
  , 10
  , 11
  , 12
  , 13
  , 14
  , 15
  , 16
  , 17
  , 18
  , 19
  , 20
  , 21
  , 22
  , 23
  , 24
  , 25
  , 26
  , 27
  , 28
  , 29
  , 30
  , 31
  , 32
  , 33
  , 34
  , 35
  , 36
  , 37
  , 38
  , 39
  , 40
  , 41
  , 42
  , 43
  , 44
  , 45
  , 46
  , 47
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , 58
  , 59
  , 60
  , 61
  , 62
  , 63
  , 64
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , 91
  , 92
  , 93
  , 94
  , 95
  , 96
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 123
  , 124
  , 125
  , 126
  , 127
  , 10
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , 46
  , -1
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 76
  , -1
  , -1
  , 128
  , 129
  , 130
  , 131
  , 132
  , 133
  , 134
  , 135
  , 136
  , 137
  , 138
  , 139
  , 140
  , 141
  , 142
  , 143
  , 144
  , 145
  , 146
  , 147
  , 148
  , 149
  , 150
  , 151
  , 152
  , 153
  , 154
  , 155
  , 156
  , 157
  , 158
  , 159
  , 160
  , 161
  , 162
  , 163
  , 164
  , 165
  , 166
  , 167
  , 168
  , 169
  , 170
  , 171
  , 172
  , 173
  , 174
  , 175
  , 176
  , 177
  , 178
  , 179
  , 180
  , 181
  , 182
  , 183
  , 184
  , 185
  , 186
  , 187
  , 188
  , 189
  , 190
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , 10
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 34
  , -1
  , -1
  , -1
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 128
  , 129
  , 130
  , 131
  , 132
  , 133
  , 134
  , 135
  , 136
  , 137
  , 138
  , 139
  , 140
  , 141
  , 142
  , 143
  , 144
  , 145
  , 146
  , 147
  , 148
  , 149
  , 150
  , 151
  , 152
  , 153
  , 154
  , 155
  , 156
  , 157
  , 158
  , 159
  , 160
  , 161
  , 162
  , 163
  , 164
  , 165
  , 166
  , 167
  , 168
  , 169
  , 170
  , 171
  , 172
  , 173
  , 174
  , 175
  , 176
  , 177
  , 178
  , 179
  , 180
  , 181
  , 182
  , 183
  , 184
  , 185
  , 186
  , 187
  , 188
  , 189
  , 190
  , 191
  , 192
  , 193
  , 194
  , 195
  , 196
  , 197
  , 198
  , 199
  , 200
  , 201
  , 202
  , 203
  , 204
  , 205
  , 206
  , 207
  , 208
  , 209
  , 210
  , 211
  , 212
  , 213
  , 214
  , 215
  , 216
  , 217
  , 218
  , 219
  , 220
  , 221
  , 222
  , 223
  , 224
  , 225
  , 226
  , 227
  , 228
  , 229
  , 230
  , 231
  , 232
  , 233
  , 234
  , 235
  , 236
  , 237
  , 238
  , 239
  , 240
  , 241
  , 242
  , 243
  , 244
  , 245
  , 246
  , 247
  , 248
  , 249
  , 250
  , 251
  , 252
  , 253
  , 254
  , 255
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 46
  , -1
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , 76
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , -1
  , -1
  , -1
  , -1
  , 88
  , 76
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , -1
  , -1
  , -1
  , -1
  , 120
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , 48
  , 49
  , 50
  , 51
  , 52
  , 53
  , 54
  , 55
  , 56
  , 57
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 65
  , 66
  , 67
  , 68
  , 69
  , 70
  , 71
  , 72
  , 73
  , 74
  , 75
  , 76
  , 77
  , 78
  , 79
  , 80
  , 81
  , 82
  , 83
  , 84
  , 85
  , 86
  , 87
  , 88
  , 89
  , 90
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , 97
  , 98
  , 99
  , 100
  , 101
  , 102
  , 103
  , 104
  , 105
  , 106
  , 107
  , 108
  , 109
  , 110
  , 111
  , 112
  , 113
  , 114
  , 115
  , 116
  , 117
  , 118
  , 119
  , 120
  , 121
  , 122
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  ]

alex_deflt :: Array Int Int
alex_deflt = listArray (0 :: Int, 155)
  [ -1
  , -1
  , -1
  , -1
  , -1
  , 10
  , 10
  , -1
  , 12
  , 12
  , 16
  , 16
  , 20
  , 20
  , 22
  , 22
  , 22
  , 1
  , 1
  , 1
  , 1
  , -1
  , 22
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  , -1
  ]

alex_accept = listArray (0 :: Int, 155)
  [ AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAccNone
  , AlexAcc 130
  , AlexAcc 129
  , AlexAcc 128
  , AlexAcc 127
  , AlexAcc 126
  , AlexAcc 125
  , AlexAcc 124
  , AlexAcc 123
  , AlexAcc 122
  , AlexAcc 121
  , AlexAcc 120
  , AlexAcc 119
  , AlexAcc 118
  , AlexAcc 117
  , AlexAcc 116
  , AlexAcc 115
  , AlexAcc 114
  , AlexAcc 113
  , AlexAcc 112
  , AlexAcc 111
  , AlexAcc 110
  , AlexAcc 109
  , AlexAcc 108
  , AlexAcc 107
  , AlexAcc 106
  , AlexAcc 105
  , AlexAcc 104
  , AlexAcc 103
  , AlexAcc 102
  , AlexAcc 101
  , AlexAcc 100
  , AlexAcc 99
  , AlexAcc 98
  , AlexAcc 97
  , AlexAcc 96
  , AlexAcc 95
  , AlexAcc 94
  , AlexAcc 93
  , AlexAcc 92
  , AlexAcc 91
  , AlexAcc 90
  , AlexAcc 89
  , AlexAcc 88
  , AlexAcc 87
  , AlexAcc 86
  , AlexAcc 85
  , AlexAcc 84
  , AlexAcc 83
  , AlexAcc 82
  , AlexAcc 81
  , AlexAcc 80
  , AlexAcc 79
  , AlexAcc 78
  , AlexAcc 77
  , AlexAcc 76
  , AlexAcc 75
  , AlexAcc 74
  , AlexAcc 73
  , AlexAcc 72
  , AlexAcc 71
  , AlexAcc 70
  , AlexAcc 69
  , AlexAcc 68
  , AlexAcc 67
  , AlexAcc 66
  , AlexAcc 65
  , AlexAcc 64
  , AlexAcc 63
  , AlexAcc 62
  , AlexAcc 61
  , AlexAcc 60
  , AlexAcc 59
  , AlexAcc 58
  , AlexAcc 57
  , AlexAcc 56
  , AlexAcc 55
  , AlexAcc 54
  , AlexAcc 53
  , AlexAcc 52
  , AlexAcc 51
  , AlexAcc 50
  , AlexAcc 49
  , AlexAcc 48
  , AlexAcc 47
  , AlexAcc 46
  , AlexAcc 45
  , AlexAcc 44
  , AlexAcc 43
  , AlexAcc 42
  , AlexAcc 41
  , AlexAcc 40
  , AlexAcc 39
  , AlexAcc 38
  , AlexAcc 37
  , AlexAcc 36
  , AlexAcc 35
  , AlexAcc 34
  , AlexAcc 33
  , AlexAcc 32
  , AlexAcc 31
  , AlexAcc 30
  , AlexAcc 29
  , AlexAcc 28
  , AlexAcc 27
  , AlexAcc 26
  , AlexAcc 25
  , AlexAcc 24
  , AlexAcc 23
  , AlexAcc 22
  , AlexAcc 21
  , AlexAcc 20
  , AlexAcc 19
  , AlexAcc 18
  , AlexAcc 17
  , AlexAcc 16
  , AlexAcc 15
  , AlexAcc 14
  , AlexAcc 13
  , AlexAcc 12
  , AlexAcc 11
  , AlexAcc 10
  , AlexAcc 9
  , AlexAcc 8
  , AlexAcc 7
  , AlexAcc 6
  , AlexAcc 5
  , AlexAcc 4
  , AlexAcc 3
  , AlexAcc 2
  , AlexAcc 1
  , AlexAcc 0
  , AlexAccSkip
  ]

alex_actions = array (0 :: Int, 131)
  [ (130,alex_action_0)
  , (129,alex_action_1)
  , (128,alex_action_2)
  , (127,alex_action_3)
  , (126,alex_action_4)
  , (125,alex_action_5)
  , (124,alex_action_6)
  , (123,alex_action_7)
  , (122,alex_action_8)
  , (121,alex_action_9)
  , (120,alex_action_10)
  , (119,alex_action_11)
  , (118,alex_action_12)
  , (117,alex_action_13)
  , (116,alex_action_14)
  , (115,alex_action_15)
  , (114,alex_action_16)
  , (113,alex_action_17)
  , (112,alex_action_18)
  , (111,alex_action_19)
  , (110,alex_action_20)
  , (109,alex_action_21)
  , (108,alex_action_22)
  , (107,alex_action_23)
  , (106,alex_action_24)
  , (105,alex_action_25)
  , (104,alex_action_26)
  , (103,alex_action_27)
  , (102,alex_action_28)
  , (101,alex_action_29)
  , (100,alex_action_30)
  , (99,alex_action_31)
  , (98,alex_action_32)
  , (97,alex_action_33)
  , (96,alex_action_34)
  , (95,alex_action_35)
  , (94,alex_action_36)
  , (93,alex_action_37)
  , (92,alex_action_38)
  , (91,alex_action_39)
  , (90,alex_action_40)
  , (89,alex_action_41)
  , (88,alex_action_42)
  , (87,alex_action_43)
  , (86,alex_action_43)
  , (85,alex_action_44)
  , (84,alex_action_45)
  , (83,alex_action_46)
  , (82,alex_action_47)
  , (81,alex_action_48)
  , (80,alex_action_48)
  , (79,alex_action_49)
  , (78,alex_action_49)
  , (77,alex_action_49)
  , (76,alex_action_49)
  , (75,alex_action_49)
  , (74,alex_action_49)
  , (73,alex_action_49)
  , (72,alex_action_49)
  , (71,alex_action_49)
  , (70,alex_action_49)
  , (69,alex_action_49)
  , (68,alex_action_49)
  , (67,alex_action_49)
  , (66,alex_action_49)
  , (65,alex_action_49)
  , (64,alex_action_49)
  , (63,alex_action_49)
  , (62,alex_action_49)
  , (61,alex_action_49)
  , (60,alex_action_49)
  , (59,alex_action_49)
  , (58,alex_action_49)
  , (57,alex_action_49)
  , (56,alex_action_49)
  , (55,alex_action_49)
  , (54,alex_action_49)
  , (53,alex_action_49)
  , (52,alex_action_49)
  , (51,alex_action_49)
  , (50,alex_action_49)
  , (49,alex_action_49)
  , (48,alex_action_49)
  , (47,alex_action_49)
  , (46,alex_action_49)
  , (45,alex_action_49)
  , (44,alex_action_49)
  , (43,alex_action_49)
  , (42,alex_action_49)
  , (41,alex_action_49)
  , (40,alex_action_49)
  , (39,alex_action_49)
  , (38,alex_action_49)
  , (37,alex_action_49)
  , (36,alex_action_49)
  , (35,alex_action_49)
  , (34,alex_action_49)
  , (33,alex_action_49)
  , (32,alex_action_49)
  , (31,alex_action_49)
  , (30,alex_action_49)
  , (29,alex_action_49)
  , (28,alex_action_49)
  , (27,alex_action_49)
  , (26,alex_action_49)
  , (25,alex_action_49)
  , (24,alex_action_49)
  , (23,alex_action_49)
  , (22,alex_action_49)
  , (21,alex_action_49)
  , (20,alex_action_49)
  , (19,alex_action_49)
  , (18,alex_action_49)
  , (17,alex_action_49)
  , (16,alex_action_49)
  , (15,alex_action_49)
  , (14,alex_action_49)
  , (13,alex_action_49)
  , (12,alex_action_49)
  , (11,alex_action_49)
  , (10,alex_action_49)
  , (9,alex_action_49)
  , (8,alex_action_49)
  , (7,alex_action_49)
  , (6,alex_action_49)
  , (5,alex_action_49)
  , (4,alex_action_49)
  , (3,alex_action_49)
  , (2,alex_action_49)
  , (1,alex_action_49)
  , (0,alex_action_49)
  ]

{-# LINE 86 "Scanner.x" #-}

data Token
    = SEMICOLON
    | COMMA
    | DOT
    | ASSIGN -- assignment
    | LESSTHAN -- comparators
    | GREATERTHAN
    | LESSEQUALS
    | GREATEREQUALS
    | EQUALS
    | NOTEQUALS
    | NOT
    | ADD -- operations
    | SUB
    | MUL
    | DIV
    | LBRACE -- brackets
    | RBRACE
    | LBRACKET -- {
    | RBRACKET -- }
    | SBOPEN
    | SBCLOSE
    | ABSTRACT -- OOP keywords
    | STATIC
    | PUBLIC
    | CLASS
    | INTERFACE
    | FOR -- structure keywords
    | WHILE
    | IF
    | ELSE
    | BREAK
    | SWITCH
    | CASE
    | RETURN
    | VOID -- type keywords
    | BOOLEAN
    | JNULL
    | INT
    | CHAR
    | STRING
    | LONG
    | BOOLEANLITERALTRUE -- type values
    | BOOLEANLITERALFALSE
    | INTLITERAL Int
    | LONGLITERAL String
    | FLOATLITERAL String
    | CHARLITERAL String
    | STRINGLITERAL String
    | MEMORYADRESSLITERAL String
    | NAME String
    | WHITESPACE -- whitespace
    deriving (Eq, Show)

--scan = alexScanTokens

alex_action_0 =  \s -> SEMICOLON 
alex_action_1 =  \s -> COMMA 
alex_action_2 =  \s -> DOT 
alex_action_3 =  \s -> ASSIGN 
alex_action_4 =  \s -> LESSTHAN 
alex_action_5 =  \s -> GREATERTHAN 
alex_action_6 =  \s -> LESSEQUALS 
alex_action_7 =  \s -> GREATEREQUALS 
alex_action_8 =  \s -> EQUALS 
alex_action_9 =  \s -> NOTEQUALS 
alex_action_10 =  \s -> NOT 
alex_action_11 =  \s -> ADD 
alex_action_12 =  \s -> SUB 
alex_action_13 =  \s -> MUL 
alex_action_14 =  \s -> DIV 
alex_action_15 =  \s -> LBRACE 
alex_action_16 =  \s -> RBRACE 
alex_action_17 =  \s -> LBRACKET 
alex_action_18 =  \s -> RBRACKET 
alex_action_19 =  \s -> SBOPEN 
alex_action_20 =  \s -> SBCLOSE 
alex_action_21 =  \s -> ABSTRACT 
alex_action_22 =  \s -> STATIC 
alex_action_23 =  \s -> PUBLIC 
alex_action_24 =  \s -> CLASS 
alex_action_25 =  \s -> INTERFACE 
alex_action_26 =  \s -> FOR 
alex_action_27 =  \s -> WHILE 
alex_action_28 =  \s -> IF 
alex_action_29 =  \s -> ELSE 
alex_action_30 =  \s -> BREAK 
alex_action_31 =  \s -> SWITCH 
alex_action_32 =  \s -> CASE 
alex_action_33 =  \s -> RETURN 
alex_action_34 =  \s -> VOID 
alex_action_35 =  \s -> BOOLEAN 
alex_action_36 =  \s -> JNULL 
alex_action_37 =  \s -> INT 
alex_action_38 =  \s -> CHAR 
alex_action_39 =  \s -> STRING 
alex_action_40 =  \s -> LONG 
alex_action_41 =  \s -> BOOLEANLITERALTRUE 
alex_action_42 =  \s -> BOOLEANLITERALFALSE 
alex_action_43 =  \s -> INTLITERAL (read s) 
alex_action_44 =  \s -> LONGLITERAL s 
alex_action_45 =  \s -> FLOATLITERAL s 
alex_action_46 =  \s -> CHARLITERAL s 
alex_action_47 =  \s -> STRINGLITERAL s 
alex_action_48 =  \s -> MEMORYADRESSLITERAL s 
alex_action_49 =  \s -> NAME s 
{-# LINE 1 "templates/GenericTemplate.hs" #-}
-- -----------------------------------------------------------------------------
-- ALEX TEMPLATE
--
-- This code is in the PUBLIC DOMAIN; you may copy it freely and use
-- it for any purpose whatsoever.

-- -----------------------------------------------------------------------------
-- INTERNALS and main scanner engine































































alexIndexInt16OffAddr arr off = arr ! off




















alexIndexInt32OffAddr arr off = arr ! off











quickIndex arr i = arr ! i


-- -----------------------------------------------------------------------------
-- Main lexing routines

data AlexReturn a
  = AlexEOF
  | AlexError  !AlexInput
  | AlexSkip   !AlexInput !Int
  | AlexToken  !AlexInput !Int a

-- alexScan :: AlexInput -> StartCode -> AlexReturn a
alexScan input__ (sc)
  = alexScanUser undefined input__ (sc)

alexScanUser user__ input__ (sc)
  = case alex_scan_tkn user__ input__ (0) input__ sc AlexNone of
  (AlexNone, input__') ->
    case alexGetByte input__ of
      Nothing ->



                                   AlexEOF
      Just _ ->



                                   AlexError input__'

  (AlexLastSkip input__'' len, _) ->



    AlexSkip input__'' len

  (AlexLastAcc k input__''' len, _) ->



    AlexToken input__''' len (alex_actions ! k)


-- Push the input through the DFA, remembering the most recent accepting
-- state it encountered.

alex_scan_tkn user__ orig_input len input__ s last_acc =
  input__ `seq` -- strict in the input
  let
  new_acc = (check_accs (alex_accept `quickIndex` (s)))
  in
  new_acc `seq`
  case alexGetByte input__ of
     Nothing -> (new_acc, input__)
     Just (c, new_input) ->



      case fromIntegral c of { (ord_c) ->
        let
                base   = alexIndexInt32OffAddr alex_base s
                offset = (base + ord_c)
                check  = alexIndexInt16OffAddr alex_check offset

                new_s = if (offset >= (0)) && (check == ord_c)
                          then alexIndexInt16OffAddr alex_table offset
                          else alexIndexInt16OffAddr alex_deflt s
        in
        case new_s of
            (-1) -> (new_acc, input__)
                -- on an error, we want to keep the input *before* the
                -- character that failed, not after.
            _ -> alex_scan_tkn user__ orig_input (if c < 0x80 || c >= 0xC0 then (len + (1)) else len)
                                                -- note that the length is increased ONLY if this is the 1st byte in a char encoding)
                        new_input new_s new_acc
      }
  where
        check_accs (AlexAccNone) = last_acc
        check_accs (AlexAcc a  ) = AlexLastAcc a input__ (len)
        check_accs (AlexAccSkip) = AlexLastSkip  input__ (len)

        check_accs (AlexAccPred a predx rest)
           | predx user__ orig_input (len) input__
           = AlexLastAcc a input__ (len)
           | otherwise
           = check_accs rest
        check_accs (AlexAccSkipPred predx rest)
           | predx user__ orig_input (len) input__
           = AlexLastSkip input__ (len)
           | otherwise
           = check_accs rest


data AlexLastAcc
  = AlexNone
  | AlexLastAcc !Int !AlexInput !Int
  | AlexLastSkip     !AlexInput !Int

data AlexAcc user
  = AlexAccNone
  | AlexAcc Int
  | AlexAccSkip

  | AlexAccPred Int (AlexAccPred user) (AlexAcc user)
  | AlexAccSkipPred (AlexAccPred user) (AlexAcc user)

type AlexAccPred user = user -> AlexInput -> Int -> AlexInput -> Bool

-- -----------------------------------------------------------------------------
-- Predicates on a rule

alexAndPred p1 p2 user__ in1 len in2
  = p1 user__ in1 len in2 && p2 user__ in1 len in2

--alexPrevCharIsPred :: Char -> AlexAccPred _
alexPrevCharIs c _ input__ _ _ = c == alexInputPrevChar input__

alexPrevCharMatches f _ input__ _ _ = f (alexInputPrevChar input__)

--alexPrevCharIsOneOfPred :: Array Char Bool -> AlexAccPred _
alexPrevCharIsOneOf arr _ input__ _ _ = arr ! alexInputPrevChar input__

--alexRightContext :: Int -> AlexAccPred _
alexRightContext (sc) user__ _ _ input__ =
     case alex_scan_tkn user__ input__ (0) input__ sc AlexNone of
          (AlexNone, _) -> False
          _ -> True
        -- TODO: there's no need to find the longest
        -- match when checking the right context, just
        -- the first match will do.

