module Main where

import Scanner


{- Grammatik Skizze:

statements -> EOF
    | statement statements

statement -> IF ifThenElsestatement
    | WHILE whilestatement
    | LBRACKET block
    | SEMICOLON
    | RETURN returnstatement

ifthenElsestatement -> bexpression statement maybeElse
maybeElse -> ELSE statement
    | EOF

whilestatement -> bexpression statement

block -> RBRACKET
    | statements RBRACKET

blockstatements -> RBRACKET
    | statement blockstatements

returnstatement -> SEMICOLON
    | expression

expression -> 1 SEMICOLON

bexpression -> LBRACE TRUE RBRACE

-}

statements :: [Token] -> [Token]
statements [] = []
statements tokens = let rest = statement tokens in statements rest

statement (IF : tokens) = ifThenElsestatement tokens    
statement (SEMICOLON : tokens) = tokens
statement (RETURN : tokens) = returnstatement tokens
statement (WHILE : tokens) = whilestatement tokens
statement (LBRACKET : tokens) = block tokens

ifThenElsestatement tokens = let rest = bexpression tokens in 
    let rest' = statement rest in maybeElse rest'

bexpression (LBRACE : BOOLEANLITERALTRUE : RBRACE : rest) = rest

maybeElse [] = []
maybeElse (ELSE : tokens) = statement tokens

returnstatement (SEMICOLON : tokens) = tokens
returnstatement tokens = expression tokens
 
expression ((INTLITERAL 1) : SEMICOLON : tokens) = tokens

whilestatement tokens = let rest = bexpression tokens in statement rest
block (RBRACKET : tokens) = tokens
block tokens = blockstatements tokens

blockstatements (RBRACKET : tokens) = tokens
blockstatements tokens = let rest = statement tokens in blockstatements rest

parser = statements . alexScanTokens

main = do
  s <- return "if () while (true) ; else {; return 1;}"
  print ("Eingabe: " ++ s)
  print ("Scanner: " ++ (show (alexScanTokens s)))
  print  $ "Parser: " ++ (show (parser s))
